#ifndef __C_DEBUGLAYERPARAM_H
#define __C_DEBUGLAYERPARAM_H

#include "Interfaces/cObject.h"
#include <string.h>

/*
 * cDebugLayerParam.h
 *
 * Parameter set for a debug layer.
 */
class cDebugLayerParam : public cParam
{
  public:
	cDebugLayerParam() { ResetToDefault(); }

	void ResetToDefault()
	{
		strcpy(mName, "Debug Layer");
		mProbDropOutgoingMsg = 0;	
		mProbDropIncomingMsg = 0;
		mPrintIncomingMsgs	 = false;
		mPrintOutgoingMsgs	 = false;
		mPrintDrop			 = false;
	}

	// Values
	char mName[80];
	bool mPrintIncomingMsgs;	// true | false
	bool mPrintOutgoingMsgs;	// true | false
	bool mPrintDrop;			// true | false	 (print to cerr when a msg is dropped)
	int	 mProbDropOutgoingMsg;	// Between 0 and RAND_MAX
	int	 mProbDropIncomingMsg;	// Between 0 and RAND_MAX

};

#endif